// Wikipedia̋LǗ邽߂̃NX
#include "stdafx.h"
#include "WikipediaArticle.h"

using namespace wpts;

// WikipediaArticle::Link

/*  */
void WikipediaFormat::Link::Initialize(void)
{
	// RXgN^̑ɁAKvȂ炱ŏ
	Text = nullptr;
	Article = nullptr;
	Section = nullptr;
	PipeTexts = gcnew array<String^>(0);
	Code = nullptr;
	TemplateFlag = false;
	SubPageFlag = false;
	StartColonFlag = false;
	MsgnwFlag = false;
	EnterFlag = false;
}

/* ݂TextȊO̒lAText𐶐 */
String^ WikipediaFormat::Link::MakeText(void)
{
	// ߂l
	String ^result = "";
	// g̐ݒ
	String ^startSign = "[[";
	String ^endSign = "]]";
	if(TemplateFlag){
		startSign = "{{";
		endSign = "}}";
	}
	// 擪̘g̕t
	result += startSign;
	// 擪 : ̕t
	if(StartColonFlag){
		result += ":";
	}
	// msgnw: iev[g<nowiki>^Oŋށj̕t
	if(TemplateFlag && MsgnwFlag){
		result += const_cast<String^>(MSGNW);
	}
	// R[hEvWFNgR[h̕t
	if(!String::IsNullOrEmpty(Code)){
		result += Code;
	}
	// N̕t
	if(!String::IsNullOrEmpty(Article)){
		result += Article;
	}
	// ZNV̕t
	if(!String::IsNullOrEmpty(Section)){
		result += ("#" + Section);
	}
	// s̕t
	if(EnterFlag){
		result += '\n';
	}
	// pCv̕̕t
	if(PipeTexts != nullptr){
		for each(String ^text in PipeTexts){
			result += "|";
			if(!String::IsNullOrEmpty(text)){
				result += text;
			}
		}
	}
	// I̘g̕t
	result += endSign;
	return result;
}


// WikipediaFormat

/* RXgN^iT[o[wj */
WikipediaFormat::WikipediaFormat(WikipediaInformation ^i_Server)
{
	// K{ȏ񂪐ݒ肳ĂȂꍇAArgumentNullExceptionԂ
	if(i_Server == nullptr){
		throw gcnew ArgumentNullException("i_Server");
	}
	// oϐ̏
	_Server = i_Server;
}

/* nꂽLJeS[`FbN */
bool WikipediaFormat::IsCategory(String ^i_Name)
{
	// w肳ꂽLJeS[iCategory:Ŏn܂j`FbN
	String ^category = Server->GetNamespace(Server->CATEGORYNAMESPACENUMBER);
	if(category != ""){
		if(i_Name->ToLower()->StartsWith(category->ToLower() + ":") == true){
			return true;
		}
	}
	return false;
}

/* nꂽL摜`FbN */
bool WikipediaFormat::IsImage(String ^i_Name)
{
	// w肳ꂽL摜iImage:Ŏn܂j`FbN
	// {ł݂ɁAimage: ƌŗL 摜: ݂Ȃ̂Ǝv̂ŁA
	//   |󌳌Ɖpł̐ݒŃ`FbN
	for(int i = 0 ; i < 2 ; i++){
		String ^image = Server->GetNamespace(Server->IMAGENAMESPACENUMBER);
		if(i == 1){
			if(Server->Code == "en"){
				continue;
			}
			WikipediaInformation en("en");
			image = en.GetNamespace(en.IMAGENAMESPACENUMBER);
		}
		if(image != ""){
			if(i_Name->ToLower()->StartsWith(image->ToLower() + ":") == true){
				return true;
			}
		}
	}
	return false;
}

/* nꂽLWOԈȊO`FbN */
bool WikipediaFormat::IsNotMainNamespace(String ^i_Name)
{
	// w肳ꂽLWOԈȊO̖OԁiWikipedia:Ŏn܂j`FbN
	for each(WikipediaInformation::Namespace ns in Server->Namespaces){
		if(i_Name->ToLower()->StartsWith(ns.Name->ToLower() + ":") == true){
			return true;
		}
	}
	return false;
}

/* nꂽWikipedia̓N */
WikipediaFormat::Link WikipediaFormat::ParseInnerLink(String ^i_Text)
{
	// o͒l
	Link result;
	result.Initialize();
	// ͒lmF
	if(i_Text->StartsWith("[[") == false){
		return result;
	}

	// \͂āA[[]]̕擾
	// \Wikipediãvr[ŐFXĊmFAȂԈĂ肷邩EEE
	String ^article = "";
	String ^section = "";
	array<String^> ^pipeTexts = gcnew array<String^>(0);
	int lastIndex = -1;
	int pipeCounter = 0;
	bool sharpFlag = false;
	for(int i = 2 ; i < i_Text->Length ; i++){
		wchar_t c = i_Text[i];
		// ]]AI
		if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, "]]") == true){
			lastIndex = ++i;
			break;
		}
		// | ܂܂ĂꍇAȍ~͕̕\ȂǂƂĈ
		if(c == '|'){
			++pipeCounter;
			MYAPP::Cmn::AddArray(pipeTexts, "");
			continue;
		}
		// ϐi[[{{{1}}}]]Ƃj̍ċA`FbN
		String ^dummy = "";
		String ^variable = "";
		int index = ChkVariable(variable, dummy, i_Text, i);
		if(index != -1){
			i = index;
			if(pipeCounter > 0){
				pipeTexts[pipeCounter - 1] += variable;
			}
			else if(sharpFlag){
				section += variable;
			}
			else{
				article += variable;
			}
			continue;
		}

		// | ̑ÔƂ
		if(pipeCounter <= 0){
			// ϐȊO { } ܂ < > [ ] \n ܂܂ĂꍇAN͖
			if((c == '<') || (c == '>') || (c == '[') || (c == ']') || (c == '{') || (c == '}') || (c == '\n')){
				break;
			}

			// # ̑ÔƂ
			if(!sharpFlag){
				// #܂܂ĂꍇAȍ~͌̕oւ̃NƂĈi1߂#̂ݗLj
				if(c == '#'){
					sharpFlag = true;
				}
				else{
					article += c;
				}
			}
			// # ̌̂Ƃ
			else{
				section += c;
			}
		}
		// | ̌̂Ƃ
		else{
			// Rgi<!--j܂܂ĂꍇAN͖
			if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, const_cast<String^>(COMMENTSTART)) == true){
				break;
			}
			// nowikĩ`FbN
			String ^nowiki = "";
			index = ChkNowiki(nowiki, i_Text, i);
			if(index != -1){
				i = index;
				pipeTexts[pipeCounter - 1] += nowiki;
				continue;
			}
			// N [[ {{ i[[image:xx|[[test]]̉摜]]Ƃj̍ċA`FbN
			Link link;
			index = ChkLinkText(link, i_Text, i);
			if(index != -1){
				i = index;
				pipeTexts[pipeCounter - 1] += link.Text;
				continue;
			}
			pipeTexts[pipeCounter - 1] += c;
		}
	}
	// ͂ɐꍇAʂ߂lɐݒ
	if(lastIndex != -1){
		// ϐubN̕ÑeLXgɐݒ
		result.Text = i_Text->Substring(0, lastIndex + 1);
		// ÕXy[X͍폜io͌̂݁j
		result.Article = article->Trim();
		result.Section = section->TrimEnd();
		// | ȍ~͂̂܂ܐݒ
		result.PipeTexts = pipeTexts;
		// L𒊏o
		// Tuy[W
		if(result.Article->StartsWith("/") == true){
			result.SubPageFlag = true;
		}
		// 擪 :
		else if(result.Article->StartsWith(":")){
			result.StartColonFlag = true;
			result.Article = result.Article->TrimStart(':')->TrimStart();
		}
		// WOԈȊO[[xxx:yyy]]̂悤ɂȂĂꍇAR[h
		if(result.Article->Contains(":") == true && !IsNotMainNamespace(result.Article)){
			// {́AR[ḧꗗAƈv̂EEEƂׂ낤A
			//   eȂ̂ : ܂ޖOԈȊOSČR[hƔ
			result.Code = result.Article->Substring(0, result.Article->IndexOf(':'))->TrimEnd();
			result.Article = result.Article->Substring(result.Article->IndexOf(':') + 1)->TrimStart();
		}
	}
	return result;
}

/* nꂽWikipediãev[g */
WikipediaFormat::Link WikipediaFormat::ParseTemplate(String ^i_Text)
{
	// o͒l
	Link result;
	result.Initialize();
	result.TemplateFlag = true;
	// ͒lmF
	if(i_Text->StartsWith("{{") == false){
		return result;
	}

	// \͂āA{{}}̕擾
	// \Wikipediãvr[ŐFXĊmFAȂԈĂ肷邩EEE
	String ^article = "";
	array<String^> ^pipeTexts = gcnew array<String^>(0);
	int lastIndex = -1;
	int pipeCounter = 0;
	for(int i = 2 ; i < i_Text->Length ; i++){
		wchar_t c = i_Text[i];
		// }}AI
		if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, "}}") == true){
			lastIndex = ++i;
			break;
		}
		// | ܂܂ĂꍇAȍ~͈̕ȂǂƂĈ
		if(c == '|'){
			++pipeCounter;
			MYAPP::Cmn::AddArray(pipeTexts, "");
			continue;
		}
		// ϐi[[{{{1}}}]]Ƃj̍ċA`FbN
		String ^dummy = "";
		String ^variable = "";
		int index = ChkVariable(variable, dummy, i_Text, i);
		if(index != -1){
			i = index;
			if(pipeCounter > 0){
				pipeTexts[pipeCounter - 1] += variable;
			}
			else{
				article += variable;
			}
			continue;
		}

		// | ̑ÔƂ
		if(pipeCounter <= 0){
			// ϐȊO < > [ ] { } ܂܂ĂꍇAN͖
			if((c == '<') || (c == '>') || (c == '[') || (c == ']') || (c == '{') || (c == '}')){
				break;
			}
			article += c;
		}
		// | ̌̂Ƃ
		else{
			// Rgi<!--j܂܂ĂꍇAN͖
			if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, const_cast<String^>(COMMENTSTART)) == true){
				break;
			}
			// nowikĩ`FbN
			String ^nowiki = "";
			index = ChkNowiki(nowiki, i_Text, i);
			if(index != -1){
				i = index;
				pipeTexts[pipeCounter - 1] += nowiki;
				continue;
			}
			// N [[ {{ i{{test|[[]]}}Ƃj̍ċA`FbN
			Link link;
			index = ChkLinkText(link, i_Text, i);
			if(index != -1){
				i = index;
				pipeTexts[pipeCounter - 1] += link.Text;
				continue;
			}
			pipeTexts[pipeCounter - 1] += c;
		}
	}
	// ͂ɐꍇAʂ߂lɐݒ
	if(lastIndex != -1){
		// ϐubN̕ÑeLXgɐݒ
		result.Text = i_Text->Substring(0, lastIndex + 1);
		// ÕXy[XEs͍폜io͌̂݁j
		result.Article = article->Trim();
		// | ȍ~͂̂܂ܐݒ
		result.PipeTexts = pipeTexts;
		// L𒊏o
		// Tuy[W
		if(result.Article->StartsWith("/") == true){
			result.SubPageFlag = true;
		}
		// 擪 :
		else if(result.Article->StartsWith(":")){
			result.StartColonFlag = true;
			result.Article = result.Article->TrimStart(':')->TrimStart();
		}
		// 擪 msgnw:
		result.MsgnwFlag = result.Article->ToLower()->StartsWith(const_cast<String^>(MSGNW)->ToLower());
		if(result.MsgnwFlag){
			result.Article = result.Article->Substring(const_cast<String^>(MSGNW)->Length);
		}
		// L̉s̗L
		if(article->TrimEnd(' ')->EndsWith("\n")){
			result.EnterFlag = true;
		}
	}
	return result;
}

/* nꂽeLXg̎w肳ꂽʒuɑ݂Wikipedia̓NEev[g`FbN */
// 펞̖߂lɂ́A]]̌]̈ʒũCfbNXԂBُ펞-1
int WikipediaFormat::ChkLinkText(Link %o_Link, String ^i_Text, int i_Index)
{
	// o͒l
	int lastIndex = -1;
	o_Link.Initialize();
	// ͒lɉāAU蕪
	if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i_Index, "[[") == true){
		// N
		o_Link = ParseInnerLink(i_Text->Substring(i_Index));
	}
	else if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i_Index, "{{") == true){
		// ev[g
		o_Link = ParseTemplate(i_Text->Substring(i_Index));
	}
	// ʊmF
	if(!String::IsNullOrEmpty(o_Link.Text)){
		lastIndex = i_Index + o_Link.Text->Length - 1;
	}
	return lastIndex;
}

/* nꂽeLXg̎w肳ꂽʒuɑ݂ϐ */
int WikipediaFormat::ChkVariable(String ^%o_Variable, String ^%o_Value, String ^i_Text, int i_Index)
{
	// o͒l
	int lastIndex = -1;
	o_Variable = "";
	o_Value = "";
	// ͒lmF
	if(MYAPP::Cmn::ChkTextInnerWith(i_Text->ToLower(), i_Index, "{{{") == false){
		return lastIndex;
	}
	// ubNI܂Ŏ擾
	bool pipeFlag = false;
	for(int i = i_Index + 3; i < i_Text->Length ; i++){
		// Ĩ`FbN
		if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, "}}}") == true){
			lastIndex = i + 2;
			break;
		}
		// Rgi<!--j̃`FbN
		String ^dummy = "";
		int index = WikipediaArticle::ChkComment(dummy, i_Text, i);
		if(index != -1){
			i = index;
			continue;
		}
		// | ܂܂ĂꍇAȍ~͑̕ꂽlƂĈ
		if(i_Text[i] == '|'){
			pipeFlag = true;
		}
		// | ̑ÔƂ
		else if(!pipeFlag){
			// Wikipedia̎dĺA{{{1{|\}}} ̂悤ɕϐ̗ { 
			//   ܂߂邱Ƃł悤AʂȂ̂ŁAG[Ƃ
			//   iǂӐ}ĂȂƂl͋Ȃ낤EEEj
			if(i_Text[i] == '{'){
				break;
			}
		}
		// | ̌̂Ƃ
		else{
			// nowikĩ`FbN
			String ^nowiki = "";
			index = ChkNowiki(nowiki, i_Text, i);
			if(index != -1){
				i = index;
				o_Value += nowiki;
				continue;
			}
			// ϐi{{{1|{{{2}}}}}}Ƃj̍ċA`FbN
			String ^variable = "";
			index = ChkVariable(variable, dummy, i_Text, i);
			if(index != -1){
				i = index;
				o_Value += variable;
				continue;
			}
			// N [[ {{ i{{{1|[[test]]}}}Ƃj̍ċA`FbN
			Link link;
			index = ChkLinkText(link, i_Text, i);
			if(index != -1){
				i = index;
				o_Value += link.Text;
				continue;
			}
			o_Value += i_Text[i];
		}
	}
	// ϐubN̕o͒lɐݒ
	if(lastIndex != -1){
		o_Variable = i_Text->Substring(i_Index, lastIndex - i_Index + 1);
	}
	// ȍ\ł͂ȂꍇAo͒lNA
	else{
		o_Variable = "";
		o_Value = "";
	}
	return lastIndex;
}

/* nowikiԂ̃`FbN */
int WikipediaFormat::ChkNowiki(String ^%o_Text, String ^i_Text, int i_Index)
{
	// o͒l
	int lastIndex = -1;
	o_Text = "";
	// ͒lmF
	if(MYAPP::Cmn::ChkTextInnerWith(i_Text->ToLower(), i_Index, const_cast<String^>(NOWIKISTART)->ToLower()) == false){
		return lastIndex;
	}
	// ubNI܂Ŏ擾
	for(int i = i_Index + const_cast<String^>(NOWIKISTART)->Length; i < i_Text->Length ; i++){
		// Ĩ`FbN
		if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, const_cast<String^>(NOWIKIEND)) == true){
			lastIndex = i + const_cast<String^>(NOWIKIEND)->Length - 1;
			break;
		}
		// Rgi<!--j̃`FbN
		String ^dummy = "";
		int index = WikipediaArticle::ChkComment(dummy, i_Text, i);
		if(index != -1){
			i = index;
			continue;
		}
	}
	// I肪Ȃꍇ́ASnowikiubNƔf
	if(lastIndex == -1){
		lastIndex = i_Text->Length - 1;
	}
	o_Text = i_Text->Substring(i_Index, lastIndex - i_Index + 1);
	return lastIndex;
}

/* RgԂ̃`FbN */
int WikipediaFormat::ChkComment(String ^%o_Text, String ^i_Text, int i_Index)
{
	// o͒l
	int lastIndex = -1;
	o_Text = "";
	// ͒lmF
	if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i_Index, const_cast<String^>(COMMENTSTART)) == false){
		return lastIndex;
	}
	// RgI܂Ŏ擾
	for(int i = i_Index + const_cast<String^>(COMMENTSTART)->Length; i < i_Text->Length ; i++){
		if(MYAPP::Cmn::ChkTextInnerWith(i_Text, i, const_cast<String^>(COMMENTEND)) == true){
			lastIndex = i + const_cast<String^>(COMMENTEND)->Length - 1;
			break;
		}
	}
	// I肪Ȃꍇ́ASăRgƔf
	if(lastIndex == -1){
		lastIndex = i_Text->Length - 1;
	}
	o_Text = i_Text->Substring(i_Index, lastIndex - i_Index + 1);
	return lastIndex;
}


// WikipediaArticle

/* ݒ */
void WikipediaArticle::Initialize(String ^i_Title)
{
	// K{ȏ񂪐ݒ肳ĂȂꍇAArgumentNullExceptionԂ
	if(MYAPP::Cmn::NullCheckAndTrim(i_Title)->TrimStart(':') == ""){
		throw gcnew ArgumentNullException("i_Title");
	}
	// oϐ̏
	_Title = i_Title->Trim()->TrimStart(':');
	UriBuilder ^uri = gcnew UriBuilder("http", Server->Server);
	uri->Path = (Server->ArticleXmlPath + Title);
	_Url = uri->Uri;
	_Xml = nullptr;
	_Timestamp = DateTime::MinValue;
	_Text = "";
	_Redirect = "";
	_GetArticleStatus = HttpStatusCode::PaymentRequired;
	_GetArticleException = nullptr;
}

/* L̏ڍ׏擾 */
bool WikipediaArticle::GetArticle(String ^i_UserAgent, String ^i_Referer, TimeSpan i_CacheEnabledSpan)
{
	// ƒl`FbN
	_Xml = nullptr;
	_Timestamp = DateTime::MinValue;
	_Text = "";
	_Redirect = "";
	_GetArticleStatus = HttpStatusCode::PaymentRequired;
	_GetArticleException = nullptr;
	// L̃f[^LbVWikipediaT[o[擾AXMLɊi[
	if(getCacheArticle(i_CacheEnabledSpan) == false){
		if(getServerArticle(i_UserAgent, i_Referer) == false){
			return false;
		}
	}
	// 擾ꂽXML͂Aoϐɐݒ
	// Oԏ̏㏑
	_Server->Namespaces = GetNamespaces();
	// L̐ݒ
	XmlNamespaceManager ^nsMgr = gcnew XmlNamespaceManager(Xml->NameTable);
	nsMgr->AddNamespace("ns", const_cast<String^>(XMLNS));
	XmlElement ^pageElement = safe_cast<XmlElement^>(Xml->SelectSingleNode("/ns:mediawiki/ns:page", nsMgr));
	if(pageElement != nullptr){
		// L̏㏑
		XmlElement ^titleElement = safe_cast<XmlElement^>(pageElement->SelectSingleNode("ns:title", nsMgr));
		_Title = (!String::IsNullOrEmpty(titleElement->InnerText) ? titleElement->InnerText : Title);
		// ŏIXV
		XmlElement ^timeElement = safe_cast<XmlElement^>(pageElement->SelectSingleNode("ns:revision/ns:timestamp", nsMgr));
		_Timestamp = DateTime::Parse(timeElement->InnerText);
		// L{
		XmlElement ^textElement = safe_cast<XmlElement^>(pageElement->SelectSingleNode("ns:revision/ns:text", nsMgr));
		_Text = textElement->InnerText;
		// _CNg̃`FbNsĂ
		IsRedirect();
	}
	// L݂ȂꍇAXML͎擾ł邪pagem[ĥŁA404G[ƓlɈ
	else{
		_GetArticleStatus = HttpStatusCode::NotFound;
		return false;
	}
	return true;
}

/* L̏ڍ׏擾iLbVLԂ̓ftHgj */
bool WikipediaArticle::GetArticle(String ^i_UserAgent, String ^i_Referer)
{
	// LbVL1TԂGetArticles
	// L̗L▼́A_CNgAԃN͂ȂɍXVȂ낤
	//   EEEƂƂŁÅԂɁB
	//   Kvł΁ALbVgȂݒŖ{\bh𒼐ڌĂԂ
	return GetArticle(i_UserAgent, i_Referer, TimeSpan(7, 0, 0, 0));
}

/* L̏ڍ׏擾iUserAgent, Referer, LbVLԂ̓ftHgj */
bool WikipediaArticle::GetArticle(void)
{
	// lGetArticles
	return GetArticle("", "");
}

/* LXMLT[o[擾 */
bool WikipediaArticle::getServerArticle(String ^i_UserAgent, String ^i_Referer)
{
	// ƒl`FbN
	_Xml = nullptr;
	_GetArticleStatus = HttpStatusCode::PaymentRequired;
	_GetArticleException = nullptr;
	// LXMLf[^WikipediaT[o[擾
	try{
		HttpWebRequest ^req = safe_cast<HttpWebRequest^>(WebRequest::Create(Url));
		// UserAgentݒ
		// WikipediaUserAgent̏ꍇG[ƂȂ̂ŁAKݒ肷
		if(!String::IsNullOrEmpty(i_UserAgent)){
			req->UserAgent = i_UserAgent;
		}
		else{
			Version ^ver = System::Reflection::Assembly::GetExecutingAssembly()->GetName()->Version;
			req->UserAgent = "WikipediaTranslationSupportTool/" + ver->Major + "." + String::Format("{0:D2}",ver->Minor);
		}
		// Refererݒ
		if(!String::IsNullOrEmpty(i_Referer)){
			req->Referer = i_Referer;
		}
		HttpWebResponse ^res = safe_cast<HttpWebResponse^>(req->GetResponse());
		_GetArticleStatus = res->StatusCode;

		// f[^M邽߂Stream擾Af[^擾
		// 擾XML킩́Ał͊mFȂ
		_Xml = gcnew XmlDocument();
		_Xml->Load(res->GetResponseStream());
		res->Close();

		// 擾XMLꎞtH_ɕۑ
		try{
			// ꎞtH_mF
			String ^tmpDir = Path::Combine(Path::GetTempPath(), Path::GetFileNameWithoutExtension(Application::ExecutablePath));
			if(Directory::Exists(tmpDir) == false){
				// ꎞtH_쐬
				Directory::CreateDirectory(tmpDir);
			}
			// t@C̕ۑ
			Xml->Save(Path::Combine(tmpDir, MYAPP::Cmn::ReplaceInvalidFileNameChars(Title) + ".xml"));
		}
		catch(Exception ^e){
			System::Diagnostics::Debug::WriteLine("WikipediaArticle::getServerArticle > ꎞt@C̕ۑɎs܂ : " + e->Message);
		}
	}
	catch(WebException ^e){
		// ProtocolErrorG[̏ꍇAXe[^XR[hێ
		_Xml = nullptr;
		if(e->Status == WebExceptionStatus::ProtocolError){
			_GetArticleStatus = static_cast<HttpWebResponse^>(e->Response)->StatusCode;
		}
		_GetArticleException = e;
		return false;
	}
	catch(Exception ^e){
		_Xml = nullptr;
		_GetArticleException = e;
		return false;
	}
	return true;
}

/* LXMLLbV擾 */
bool WikipediaArticle::getCacheArticle(TimeSpan i_CacheEnabledSpan)
{
	// ƒl`FbN
	_Xml = nullptr;
	_GetArticleStatus = HttpStatusCode::PaymentRequired;
	_GetArticleException = nullptr;
	// LbVgpꍇ̂
	if(i_CacheEnabledSpan > TimeSpan(0)){
		// LXMLf[^LbVt@C擾
		try{
			// ꎞt@CɃANZX
			String ^tmpFile = Path::Combine(Path::Combine(Path::GetTempPath(), Path::GetFileNameWithoutExtension(Application::ExecutablePath)), MYAPP::Cmn::ReplaceInvalidFileNameChars(Title) + ".xml");
			if(File::Exists(tmpFile) == true){
				// t@CL̂̂mF
				if((DateTime::UtcNow - File::GetLastWriteTimeUtc(tmpFile)) < i_CacheEnabledSpan){
					// t@CStreamŊJAf[^擾
					XmlDocument ^tmpXml = gcnew XmlDocument();
					FileStream ^fs = File::OpenRead(tmpFile);
					try{
						tmpXml->Load(fs);
					}
					finally{
						fs->Close();
					}
					// 擾XMLt@CAړIƂL̂̂mF
					XmlNamespaceManager ^nsMgr = gcnew XmlNamespaceManager(tmpXml->NameTable);
					nsMgr->AddNamespace("ns", const_cast<String^>(XMLNS));
					XmlElement ^rootElement = tmpXml->DocumentElement;
					XmlElement ^pageElement = safe_cast<XmlElement^>(tmpXml->SelectSingleNode("/ns:mediawiki/ns:page/ns:title", nsMgr));
					if(pageElement != nullptr){
						// R[hEL`FbNB啶EقȂꍇAʂ̋LƔʂ
						// Low Earth orbitւ̃_CNgLow earth orbit݂Ȃ̂邽
						//   擪Wikipedia̋ZpIŏɑ啶Ȃ߁A啶ŏ
						String ^title = wchar_t::ToUpper(Title[0]).ToString();
						if(Title->Length > 1){
							title += Title->Substring(1);
						}
						if(rootElement->GetAttribute("xml:lang") == Server->Code &&
						   pageElement->InnerText == title){
							// XMLoϐɐݒ肵AI
							System::Diagnostics::Debug::WriteLine("WikipediaArticle::getCacheArticle > LbVǍ : " + MYAPP::Cmn::ReplaceInvalidFileNameChars(Title) + ".xml");
							_Xml = tmpXml;
							return true;
						}
					}
				}
			}
		}
		catch(Exception ^e){
			_Xml = nullptr;
			_GetArticleException = e;
			return false;
		}
	}
	_GetArticleStatus = HttpStatusCode::NotFound;
	return false;
}

/* w肳ꂽR[hւ̌ԃNԂ */
String^ WikipediaArticle::GetInterWiki(String ^i_Code)
{
	// ƒl`FbN
	String ^interWiki = "";
	if(Text == ""){
		// GetArticlesĂȂꍇAInvalidOperationExceptionԂ
		throw gcnew InvalidOperationException();
	}
	// Lɑ݂w茾ւ̌ԃN擾
	for(int i = 0 ; i < Text->Length ; i++){
		// Rgi<!--j̃`FbN
		String ^comment = "";
		int index = chkComment(comment, i);
		if(index != -1){
			i = index;
		}
		// w茾ւ̌ԃN̏ꍇAe擾AI
		else if(MYAPP::Cmn::ChkTextInnerWith(Text, i, "[[" + i_Code + ":") == true){
			Link link = ParseInnerLink(Text->Substring(i));
			if(!String::IsNullOrEmpty(link.Text)){
				interWiki = link.Article;
				break;
			}
		}
	}
	return interWiki;
}

/* LXML疼Oԏ擾 */
array<WikipediaInformation::Namespace>^ WikipediaArticle::GetNamespaces(void)
{
	// XML疼Oԏ擾
	array<WikipediaInformation::Namespace> ^namespaces = gcnew array<WikipediaInformation::Namespace>(0);
	if(Xml == nullptr){
		// GetArticlesĂȂꍇAInvalidOperationExceptionԂ
		throw gcnew InvalidOperationException();
	}
	XmlNamespaceManager ^nsMgr = gcnew XmlNamespaceManager(Xml->NameTable);
	nsMgr->AddNamespace("ns", const_cast<String^>(XMLNS));
	XmlNodeList ^nodeList = Xml->SelectNodes("/ns:mediawiki/ns:siteinfo/ns:namespaces/ns:namespace", nsMgr);
	for each(XmlNode ^node in nodeList){
		XmlElement ^e = safe_cast<XmlElement^>(node);
		if(e != nullptr){
			try{
				WikipediaInformation::Namespace ns = {Decimal::ToInt16(Decimal::Parse(e->GetAttribute("key"))), e->InnerText};
				MYAPP::Cmn::AddArray(namespaces, ns);
			}
			catch(...){}
		}
	}
	return namespaces;
}

/* L_CNg`FbN */
bool WikipediaArticle::IsRedirect(void)
{
	// l`FbN
	if(Text == ""){
		// GetArticlesĂȂꍇAInvalidOperationExceptionԂ
		throw gcnew InvalidOperationException();
	}
	// w肳ꂽL_CNgLi#REDIRECTj`FbN
	// {ł݂ɁA#REDIRECTƌŗL#]݂Ȃ̂Ǝv̂ŁA
	//   |󌳌Ɖpł̐ݒŃ`FbN
	for(int i = 0 ; i < 2 ; i++){
		String ^redirect = static_cast<String^>(Server->Redirect->Clone());
		if(i == 1){
			if(Server->Code == "en"){
				continue;
			}
			WikipediaInformation en("en");
			redirect = en.Redirect;
		}
		if(redirect != ""){
			if(Text->ToLower()->StartsWith(redirect->ToLower()) == true){
				Link link = ParseInnerLink(Text->Substring(redirect->Length)->TrimStart());
				if(!String::IsNullOrEmpty(link.Text)){
					_Redirect = link.Article;
					return true;
				}
			}
		}
	}
	return false;
}

/* LJeS[`FbN */
bool WikipediaArticle::IsCategory(void)
{
	return IsCategory(Title);
}

/* L摜`FbN */
bool WikipediaArticle::IsImage(void)
{
	return IsImage(Title);
}

/* LWOԈȊO`FbN */
bool WikipediaArticle::IsNotMainNamespace(void)
{
	return IsNotMainNamespace(Title);
}

/* nꂽNEev[g */
int WikipediaArticle::chkLinkText(WikipediaFormat::Link %o_Link, int i_Index)
{
	return ChkLinkText(o_Link, Text, i_Index);
}

/* L{̎w肳ꂽʒuɑ݂NEev[g */
int WikipediaArticle::chkComment(String ^%o_Text, int i_Index)
{
	return ChkComment(o_Text, Text, i_Index);
}
